var samplePageObj = {
  // 샘플 타이틀
  title: '상단/하단 행고정',
  subtitle: '데이터 상단/하단에 고정된 행을 두고, 원하는 타입이나 값을 설정할 수 있습니다.',

  // 샘플 설명
  desc: '여러줄의 헤더행 설정이 가능하며, 시트 상단(Head)/하단(Foot)에 고정행을 설정하여 임의로 데이터를 세팅할 수 있습니다. <br>이렇게 고정된 행은 각 셀별 타입, 스타일, 포맷등을 해당컬럼의 기본값과 다르게 적용할 수 있습니다.',

  // 객체 초기화 구문
  init: {
    Def: {
      Col: {
        Spanned: 1,
        Width: '120'
      },
      // Head에 반영되는 전역 설정
      MyHead: {
        Spanned: 1,
        Color: '#D3E1C3', // 배경색 설정
        HtmlPrefix: '<span style=\'color: #485B34; font-weight: bold;\'>', // HtmlPrefix를 셀의 Value 이전에 적용가능
        HtmlPostfix: '</span>', // HtmlPostfix를 셀의 Value 이후에 적용가능
      },
      // Foot에 반영되는 전역 설정
      MyFoot: {
        Spanned: 1, // ColSpan 또는 RowSpan 을 사용하기 위한 설정 {0:사용불가, 1:사용가능}
        CanFocus: 0, // 쿨릭 했을 경우 포커스 가능여부를 설정
        CanFormula: 1, // 로우가 정의된 Formula 속성에 따라 계산 될지 여부 설정
        Color: '#f0ede6', // 배경색 설정
        HtmlPrefix: '<span style=\'color: #FF6407; font-weight: bold;\'>', // HtmlPrefix를 셀의 Value 이전에 적용가능
        HtmlPostfix: '</span>', // HtmlPostfix를 셀의 Value 이후에 적용가능
      }
    },
    Cfg: {
      SearchMode: 0,
      FocuseWholeRow: 1,
      HeaderMerge: 6,
      PrevColumnMerge: 0
    },
    Cols: [
      {
        Header: [
          'No',
          'No',
          'No'
        ],
        Type: 'Text',
        Name: 'SEQ',
        Width: '80'
      },
      {
        Header: [
          '기간',
          '기간',
          '기간'
        ],
        Type: 'Date',
        Name: 'sDate',
        CanEdit: 1,
        Format: 'yyyy/MM',
        DataFormat: 'yyyyMM'
      },
      {
        Header: [
          {
            Value: '경제활동인구',
            Color: '#085820'
          },
          {
            Value: '경제활동인구',
            Color: '#085820'
          },
          '소계'
        ],
        Type: 'Int',
        Name: 'sActSum',
        Formula: 'sActM+sActW'
      },
      {
        Header: [
          '경제활동인구',
          '경제활동인구',
          '남자'
        ],
        Type: 'Int',
        Name: 'sActM'
      },
      {
        Header: [
          '경제활동인구',
          '경제활동인구',
          '여자'
        ],
        Type: 'Int',
        Name: 'sActW'
      },

      {
        Header: [
          '경제활동인구',
          {
            Value: '취업자',
            Color: '#085820'
          },
          '소계'
        ],
        Type: 'Int',
        Name: 'sEmplySum',
        CanEdit: 0,
        Formula: 'sEmplyM+sEmplyW'
      },
      {
        Header: [
          '경제활동인구',
          '취업자',
          '남자'
        ],
        Type: 'Int',
        Name: 'sEmplyM'
      },
      {
        Header: [
          '경제활동인구',
          '취업자',
          '여자'
        ],
        Type: 'Int',
        Name: 'sEmplyW'
      },

      {
        Header: [
          '경제활동인구',
          {
            Value: '실업자',
            Color: '#085820'
          },
          '소계'
        ],
        Type: 'Int',
        Name: 'sUnemplySum',
        CanEdit: 0,
        Formula: 'sUnemplyM+sUnemplyW'
      },
      {
        Header: [
          '경제활동인구',
          '실업자',
          '남자'
        ],
        Type: 'Int',
        Name: 'sUnemplyM'
      },
      {
        Header: [
          '경제활동인구',
          '실업자',
          '여자'
        ],
        Type: 'Int',
        Name: 'sUnemplyW'
      },

      {
        Header: [
          {
            Value: '비경제활동인구',
            Color: '#6699FF'
          },
          '비경제활동인구',
          '소계'
        ],
        Type: 'Int',
        Name: 'sInactSum',
        CanEdit: 0,
        Formula: 'sInactM+sInactW',
        RelWidth: 1
      },
      {
        Header: [
          '비경제활동인구',
          '비경제활동인구',
          '남자'
        ],
        Type: 'Int',
        Name: 'sInactM',
        RelWidth: 1
      },
      {
        Header: [
          '비경제활동인구',
          '비경제활동인구',
          '여자'
        ],
        Type: 'Int',
        Name: 'sInactW',
        RelWidth: 1
      },
    ],
    // 헤더행 아래 고정행
    Head: [
      {
        id: 'myHeadRow1', // 헤더행 ID
        Kind: 'Head',
        Def: 'MyHead',
        SEQ: {
          Type: 'Text',
          Value: '남/여 합계 계산',
          Span: 2,
          Align: 'center'
        },
        sActSum: {
          Type: 'Text',
          Value: ''
        },
        sActM: {
          Type: 'Bool',
          Value: 1
        },
        sActW: {
          Type: 'Bool',
          Value: 1
        },
        sEmplySum: {
          Type: 'Text',
          Value: ''
        },
        sEmplyM: {
          Type: 'Bool',
          Value: 1
        },
        sEmplyW: {
          Type: 'Bool',
          Value: 1
        },
        sUnemplySum: {
          Type: 'Text',
          Format: '',
          Formula: ''
        },
        sUnemplyM: {
          Type: 'Bool',
          Value: 1
        },
        sUnemplyW: {
          Type: 'Bool',
          Value: 1
        },
        sInactSum: {
          Type: 'Text',
          Format: '',
          Formula: ''
        },
        sInactM: {
          Type: 'Text',
          Format: '',
          CanEdit: 0
        },
        sInactW: {
          Type: 'Text',
          Format: '',
          CanEdit: 0
        },
      }
    ],
    // 시트 하단 영역
    Foot: [
      { // Foot 영역의 첫번 째 로우
        id: 'myFootRow', // id : 로우 Id를 부여
        Def: 'MyFoot', // Def에 설정된 Foot 속성을 적용
        Kind: 'Foot',
        sActSum: {
          Type: 'Text',
          Align: 'Center',
          Format: '',
          Formula: sActSumFormula, // 주어진 주건에 따라 셀 내에 지정될 값을 계산하기 위한 속성
          Span: 3,
        },
        sEmplySum: {
          Type: 'Text',
          Align: 'Center',
          Format: '',
          Formula: sEmplySumFormula, // 주어진 주건에 따라 셀 내에 지정될 값을 계산하기 위한 속성
          Span: 3,
        },
        sUnemplySum: {
          Type: 'Text',
          Align: 'Center',
          Format: '',
          Formula: sUnemplySumFormula, // 주어진 주건에 따라 셀 내에 지정될 값을 계산하기 위한 속성
          Span: 3,
        },
        sInactSum: {
          Type: 'Text',
          Align: 'Center',
          Format: '',
          Value: '출처 : 서울시 열린데이터 광장 - \'서울시 경제활동 인구 통계자료\'',
          Span: 3,
          HtmlPrefix: '<span style=\'color: #3589E6; font-weight: bold;\'>', // HtmlPrefix를 셀의 Value 이전에 적용가능
          HtmlPostfix: '</span>' // HtmlPostfix를 셀의 Value 이후에 적용가능
        }
      }
    ]

  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      sDate: '201001',
      sActSum: '5230',
      sActM: '3007',
      sActW: '2223',
      sEmplySum: '4918',
      sEmplyM: '2807',
      sEmplyW: '2111',
      sUnemplySum: '313',
      sUnemplyM: '200',
      sUnemplyW: '113',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201002',
      sActSum: '5238',
      sActM: '3003',
      sActW: '2236',
      sEmplySum: '4934',
      sEmplyM: '2809',
      sEmplyW: '2125',
      sUnemplySum: '305',
      sUnemplyM: '194',
      sUnemplyW: '110',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201003',
      sActSum: '5246',
      sActM: '3010',
      sActW: '2236',
      sEmplySum: '4973',
      sEmplyM: '2836',
      sEmplyW: '2137',
      sUnemplySum: '273',
      sUnemplyM: '174',
      sUnemplyW: '100',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201004',
      sActSum: '5322',
      sActM: '3036',
      sActW: '2286',
      sEmplySum: '5052',
      sEmplyM: '2851',
      sEmplyW: '2201',
      sUnemplySum: '270',
      sUnemplyM: '186',
      sUnemplyW: '85 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201005',
      sActSum: '5342',
      sActM: '3026',
      sActW: '2317',
      sEmplySum: '5118',
      sEmplyM: '2874',
      sEmplyW: '2244',
      sUnemplySum: '224',
      sUnemplyM: '151',
      sUnemplyW: '73 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201006',
      sActSum: '5334',
      sActM: '3030',
      sActW: '2304',
      sEmplySum: '5108',
      sEmplyM: '2880',
      sEmplyW: '2228',
      sUnemplySum: '226',
      sUnemplyM: '150',
      sUnemplyW: '76 ',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201007',
      sActSum: '5371',
      sActM: '3054',
      sActW: '2317',
      sEmplySum: '5131',
      sEmplyM: '2901',
      sEmplyW: '2230',
      sUnemplySum: '240',
      sUnemplyM: '153',
      sUnemplyW: '87 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201008',
      sActSum: '5308',
      sActM: '3038',
      sActW: '2270',
      sEmplySum: '5079',
      sEmplyM: '2888',
      sEmplyW: '2191',
      sUnemplySum: '228',
      sUnemplyM: '150',
      sUnemplyW: '79 ',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201009',
      sActSum: '5309',
      sActM: '3026',
      sActW: '2283',
      sEmplySum: '5078',
      sEmplyM: '2879',
      sEmplyW: '2199',
      sUnemplySum: '231',
      sUnemplyM: '147',
      sUnemplyW: '83 ',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201010',
      sActSum: '5336',
      sActM: '3045',
      sActW: '2291',
      sEmplySum: '5091',
      sEmplyM: '2884',
      sEmplyW: '2207',
      sUnemplySum: '244',
      sUnemplyM: '161',
      sUnemplyW: '83 ',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201011',
      sActSum: '5319',
      sActM: '3034',
      sActW: '2285',
      sEmplySum: '5102',
      sEmplyM: '2878',
      sEmplyW: '2224',
      sUnemplySum: '217',
      sUnemplyM: '156',
      sUnemplyW: '62 ',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201012',
      sActSum: '5347',
      sActM: '3040',
      sActW: '2307',
      sEmplySum: '5119',
      sEmplyM: '2895',
      sEmplyW: '2224',
      sUnemplySum: '228',
      sUnemplyM: '144',
      sUnemplyW: '83 ',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201101',
      sActSum: '5289',
      sActM: '3007',
      sActW: '2282',
      sEmplySum: '5037',
      sEmplyM: '2845',
      sEmplyW: '2192',
      sUnemplySum: '252',
      sUnemplyM: '162',
      sUnemplyW: '90 ',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201102',
      sActSum: '5353',
      sActM: '3041',
      sActW: '2311',
      sEmplySum: '5073',
      sEmplyM: '2861',
      sEmplyW: '2211',
      sUnemplySum: '280',
      sUnemplyM: '180',
      sUnemplyW: '100',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201103',
      sActSum: '5399',
      sActM: '3079',
      sActW: '2319',
      sEmplySum: '5107',
      sEmplyM: '2895',
      sEmplyW: '2212',
      sUnemplySum: '292',
      sUnemplyM: '184',
      sUnemplyW: '108',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201104',
      sActSum: '5419',
      sActM: '3089',
      sActW: '2331',
      sEmplySum: '5150',
      sEmplyM: '2915',
      sEmplyW: '2235',
      sUnemplySum: '269',
      sUnemplyM: '173',
      sUnemplyW: '96 ',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201105',
      sActSum: '5452',
      sActM: '3087',
      sActW: '2365',
      sEmplySum: '5204',
      sEmplyM: '2932',
      sEmplyW: '2272',
      sUnemplySum: '248',
      sUnemplyM: '155',
      sUnemplyW: '93 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201106',
      sActSum: '5470',
      sActM: '3097',
      sActW: '2374',
      sEmplySum: '5229',
      sEmplyM: '2946',
      sEmplyW: '2283',
      sUnemplySum: '242',
      sUnemplyM: '150',
      sUnemplyW: '91 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201107',
      sActSum: '5457',
      sActM: '3096',
      sActW: '2360',
      sEmplySum: '5225',
      sEmplyM: '2948',
      sEmplyW: '2278',
      sUnemplySum: '231',
      sUnemplyM: '149',
      sUnemplyW: '83 ',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201108',
      sActSum: '5403',
      sActM: '3084',
      sActW: '2319',
      sEmplySum: '5171',
      sEmplyM: '2933',
      sEmplyW: '2238',
      sUnemplySum: '232',
      sUnemplyM: '151',
      sUnemplyW: '81 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201109',
      sActSum: '5359',
      sActM: '3061',
      sActW: '2298',
      sEmplySum: '5122',
      sEmplyM: '2910',
      sEmplyW: '2212',
      sUnemplySum: '237',
      sUnemplyM: '151',
      sUnemplyW: '86 ',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201110',
      sActSum: '5390',
      sActM: '3081',
      sActW: '2309',
      sEmplySum: '5174',
      sEmplyM: '2942',
      sEmplyW: '2231',
      sUnemplySum: '216',
      sUnemplyM: '138',
      sUnemplyW: '78 ',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201111',
      sActSum: '5387',
      sActM: '3066',
      sActW: '2320',
      sEmplySum: '5173',
      sEmplyM: '2940',
      sEmplyW: '2233',
      sUnemplySum: '214',
      sUnemplyM: '127',
      sUnemplyW: '87 ',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201112',
      sActSum: '5359',
      sActM: '3052',
      sActW: '2308',
      sEmplySum: '5130',
      sEmplyM: '2915',
      sEmplyW: '2216',
      sUnemplySum: '229',
      sUnemplyM: '137',
      sUnemplyW: '92 ',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201201',
      sActSum: '5322',
      sActM: '3017',
      sActW: '2305',
      sEmplySum: '5075',
      sEmplyM: '2869',
      sEmplyW: '2207',
      sUnemplySum: '247',
      sUnemplyM: '148',
      sUnemplyW: '98 ',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201202',
      sActSum: '5379',
      sActM: '3045',
      sActW: '2334',
      sEmplySum: '5086',
      sEmplyM: '2871',
      sEmplyW: '2215',
      sUnemplySum: '293',
      sUnemplyM: '174',
      sUnemplyW: '119',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201203',
      sActSum: '5387',
      sActM: '3043',
      sActW: '2344',
      sEmplySum: '5128',
      sEmplyM: '2882',
      sEmplyW: '2246',
      sUnemplySum: '258',
      sUnemplyM: '160',
      sUnemplyW: '98 ',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201204',
      sActSum: '5427',
      sActM: '3045',
      sActW: '2382',
      sEmplySum: '5190',
      sEmplyM: '2901',
      sEmplyW: '2289',
      sUnemplySum: '238',
      sUnemplyM: '144',
      sUnemplyW: '93 ',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201205',
      sActSum: '5457',
      sActM: '3057',
      sActW: '2401',
      sEmplySum: '5236',
      sEmplyM: '2922',
      sEmplyW: '2314',
      sUnemplySum: '221',
      sUnemplyM: '135',
      sUnemplyW: '86 ',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201206',
      sActSum: '5448',
      sActM: '3050',
      sActW: '2398',
      sEmplySum: '5217',
      sEmplyM: '2904',
      sEmplyW: '2313',
      sUnemplySum: '231',
      sUnemplyM: '146',
      sUnemplyW: '85 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201207',
      sActSum: '5430',
      sActM: '3056',
      sActW: '2373',
      sEmplySum: '5204',
      sEmplyM: '2913',
      sEmplyW: '2291',
      sUnemplySum: '225',
      sUnemplyM: '144',
      sUnemplyW: '82 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201208',
      sActSum: '5357',
      sActM: '3041',
      sActW: '2315',
      sEmplySum: '5129',
      sEmplyM: '2901',
      sEmplyW: '2228',
      sUnemplySum: '227',
      sUnemplyM: '140',
      sUnemplyW: '88 ',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201209',
      sActSum: '5360',
      sActM: '3029',
      sActW: '2331',
      sEmplySum: '5145',
      sEmplyM: '2897',
      sEmplyW: '2248',
      sUnemplySum: '215',
      sUnemplyM: '132',
      sUnemplyW: '83 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201210',
      sActSum: '5316',
      sActM: '3031',
      sActW: '2285',
      sEmplySum: '5125',
      sEmplyM: '2915',
      sEmplyW: '2210',
      sUnemplySum: '190',
      sUnemplyM: '116',
      sUnemplyW: '75 ',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201211',
      sActSum: '5294',
      sActM: '3015',
      sActW: '2280',
      sEmplySum: '5105',
      sEmplyM: '2898',
      sEmplyW: '2207',
      sUnemplySum: '190',
      sUnemplyM: '117',
      sUnemplyW: '73 ',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201212',
      sActSum: '5276',
      sActM: '2993',
      sActW: '2283',
      sEmplySum: '5096',
      sEmplyM: '2878',
      sEmplyW: '2218',
      sUnemplySum: '180',
      sUnemplyM: '115',
      sUnemplyW: '65 ',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201301',
      sActSum: '5278',
      sActM: '2997',
      sActW: '2281',
      sEmplySum: '5073',
      sEmplyM: '2869',
      sEmplyW: '2204',
      sUnemplySum: '205',
      sUnemplyM: '128',
      sUnemplyW: '77 ',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201302',
      sActSum: '5281',
      sActM: '2981',
      sActW: '2300',
      sEmplySum: '5039',
      sEmplyM: '2837',
      sEmplyW: '2203',
      sUnemplySum: '242',
      sUnemplyM: '145',
      sUnemplyW: '97 ',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201303',
      sActSum: '5314',
      sActM: '3001',
      sActW: '2314',
      sEmplySum: '5049',
      sEmplyM: '2853',
      sEmplyW: '2196',
      sUnemplySum: '266',
      sUnemplyM: '148',
      sUnemplyW: '118',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201304',
      sActSum: '5343',
      sActM: '3000',
      sActW: '2343',
      sEmplySum: '5117',
      sEmplyM: '2878',
      sEmplyW: '2239',
      sUnemplySum: '226',
      sUnemplyM: '122',
      sUnemplyW: '104',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201305',
      sActSum: '5380',
      sActM: '3020',
      sActW: '2359',
      sEmplySum: '5151',
      sEmplyM: '2890',
      sEmplyW: '2261',
      sUnemplySum: '228',
      sUnemplyM: '130',
      sUnemplyW: '98 ',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201306',
      sActSum: '5382',
      sActM: '3019',
      sActW: '2364',
      sEmplySum: '5172',
      sEmplyM: '2904',
      sEmplyW: '2268',
      sUnemplySum: '210',
      sUnemplyM: '115',
      sUnemplyW: '96 ',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201307',
      sActSum: '5370',
      sActM: '3012',
      sActW: '2358',
      sEmplySum: '5175',
      sEmplyM: '2897',
      sEmplyW: '2278',
      sUnemplySum: '196',
      sUnemplyM: '116',
      sUnemplyW: '80 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201308',
      sActSum: '5333',
      sActM: '3012',
      sActW: '2321',
      sEmplySum: '5133',
      sEmplyM: '2883',
      sEmplyW: '2250',
      sUnemplySum: '200',
      sUnemplyM: '129',
      sUnemplyW: '71 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201309',
      sActSum: '5366',
      sActM: '3027',
      sActW: '2339',
      sEmplySum: '5184',
      sEmplyM: '2915',
      sEmplyW: '2269',
      sUnemplySum: '182',
      sUnemplyM: '111',
      sUnemplyW: '70 ',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201310',
      sActSum: '5393',
      sActM: '3033',
      sActW: '2360',
      sEmplySum: '5209',
      sEmplyM: '2920',
      sEmplyW: '2289',
      sUnemplySum: '184',
      sUnemplyM: '113',
      sUnemplyW: '71 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201311',
      sActSum: '5407',
      sActM: '3047',
      sActW: '2360',
      sEmplySum: '5216',
      sEmplyM: '2919',
      sEmplyW: '2296',
      sUnemplySum: '191',
      sUnemplyM: '128',
      sUnemplyW: '63 ',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201312',
      sActSum: '5418',
      sActM: '3047',
      sActW: '2371',
      sEmplySum: '5229',
      sEmplyM: '2929',
      sEmplyW: '2300',
      sUnemplySum: '189',
      sUnemplyM: '117',
      sUnemplyW: '71 ',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201401',
      sActSum: '5376',
      sActM: '3031',
      sActW: '2345',
      sEmplySum: '5173',
      sEmplyM: '2906',
      sEmplyW: '2267',
      sUnemplySum: '203',
      sUnemplyM: '125',
      sUnemplyW: '78 ',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201402',
      sActSum: '5467',
      sActM: '3081',
      sActW: '2386',
      sEmplySum: '5192',
      sEmplyM: '2925',
      sEmplyW: '2267',
      sUnemplySum: '275',
      sUnemplyM: '156',
      sUnemplyW: '120',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201403',
      sActSum: '5446',
      sActM: '3071',
      sActW: '2375',
      sEmplySum: '5193',
      sEmplyM: '2920',
      sEmplyW: '2273',
      sUnemplySum: '253',
      sUnemplyM: '151',
      sUnemplyW: '102',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201404',
      sActSum: '5476',
      sActM: '3082',
      sActW: '2394',
      sEmplySum: '5210',
      sEmplyM: '2938',
      sEmplyW: '2273',
      sUnemplySum: '266',
      sUnemplyM: '145',
      sUnemplyW: '121',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201405',
      sActSum: '5459',
      sActM: '3057',
      sActW: '2402',
      sEmplySum: '5200',
      sEmplyM: '2925',
      sEmplyW: '2275',
      sUnemplySum: '259',
      sUnemplyM: '132',
      sUnemplyW: '127',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201406',
      sActSum: '5443',
      sActM: '3050',
      sActW: '2393',
      sEmplySum: '5204',
      sEmplyM: '2931',
      sEmplyW: '2273',
      sUnemplySum: '239',
      sUnemplyM: '119',
      sUnemplyW: '120',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201407',
      sActSum: '5472',
      sActM: '3063',
      sActW: '2408',
      sEmplySum: '5223',
      sEmplyM: '2926',
      sEmplyW: '2297',
      sUnemplySum: '249',
      sUnemplyM: '137',
      sUnemplyW: '112',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201408',
      sActSum: '5435',
      sActM: '3050',
      sActW: '2384',
      sEmplySum: '5205',
      sEmplyM: '2916',
      sEmplyW: '2289',
      sUnemplySum: '230',
      sUnemplyM: '134',
      sUnemplyW: '95 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201409',
      sActSum: '5451',
      sActM: '3054',
      sActW: '2397',
      sEmplySum: '5217',
      sEmplyM: '2915',
      sEmplyW: '2301',
      sUnemplySum: '235',
      sUnemplyM: '139',
      sUnemplyW: '96 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201410',
      sActSum: '5463',
      sActM: '3056',
      sActW: '2407',
      sEmplySum: '5220',
      sEmplyM: '2922',
      sEmplyW: '2298',
      sUnemplySum: '243',
      sUnemplyM: '134',
      sUnemplyW: '109',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201411',
      sActSum: '5457',
      sActM: '3044',
      sActW: '2412',
      sEmplySum: '5252',
      sEmplyM: '2923',
      sEmplyW: '2329',
      sUnemplySum: '205',
      sUnemplyM: '122',
      sUnemplyW: '83 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201412',
      sActSum: '5443',
      sActM: '3047',
      sActW: '2396',
      sEmplySum: '5220',
      sEmplyM: '2910',
      sEmplyW: '2310',
      sUnemplySum: '223',
      sUnemplyM: '137',
      sUnemplyW: '86 ',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201501',
      sActSum: '5398',
      sActM: '3020',
      sActW: '2378',
      sEmplySum: '5167',
      sEmplyM: '2885',
      sEmplyW: '2282',
      sUnemplySum: '232',
      sUnemplyM: '136',
      sUnemplyW: '96 ',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201502',
      sActSum: '5395',
      sActM: '3019',
      sActW: '2377',
      sEmplySum: '5143',
      sEmplyM: '2884',
      sEmplyW: '2259',
      sUnemplySum: '252',
      sUnemplyM: '135',
      sUnemplyW: '118',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201503',
      sActSum: '5384',
      sActM: '3029',
      sActW: '2356',
      sEmplySum: '5131',
      sEmplyM: '2884',
      sEmplyW: '2247',
      sUnemplySum: '253',
      sUnemplyM: '145',
      sUnemplyW: '108',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201504',
      sActSum: '5393',
      sActM: '3029',
      sActW: '2364',
      sEmplySum: '5139',
      sEmplyM: '2880',
      sEmplyW: '2259',
      sUnemplySum: '254',
      sUnemplyM: '149',
      sUnemplyW: '105',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201505',
      sActSum: '5434',
      sActM: '3061',
      sActW: '2373',
      sEmplySum: '5200',
      sEmplyM: '2926',
      sEmplyW: '2274',
      sUnemplySum: '234',
      sUnemplyM: '135',
      sUnemplyW: '99 ',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201506',
      sActSum: '5405',
      sActM: '3029',
      sActW: '2376',
      sEmplySum: '5153',
      sEmplyM: '2889',
      sEmplyW: '2264',
      sUnemplySum: '253',
      sUnemplyM: '140',
      sUnemplyW: '112',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201507',
      sActSum: '5417',
      sActM: '3041',
      sActW: '2376',
      sEmplySum: '5193',
      sEmplyM: '2909',
      sEmplyW: '2284',
      sUnemplySum: '224',
      sUnemplyM: '133',
      sUnemplyW: '92 ',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201508',
      sActSum: '5403',
      sActM: '3031',
      sActW: '2372',
      sEmplySum: '5194',
      sEmplyM: '2913',
      sEmplyW: '2281',
      sUnemplySum: '209',
      sUnemplyM: '119',
      sUnemplyW: '91 ',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201509',
      sActSum: '5374',
      sActM: '3015',
      sActW: '2359',
      sEmplySum: '5167',
      sEmplyM: '2895',
      sEmplyW: '2272',
      sUnemplySum: '207',
      sUnemplyM: '119',
      sUnemplyW: '87 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201510',
      sActSum: '5348',
      sActM: '2998',
      sActW: '2350',
      sEmplySum: '5157',
      sEmplyM: '2891',
      sEmplyW: '2266',
      sUnemplySum: '191',
      sUnemplyM: '107',
      sUnemplyW: '84 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201511',
      sActSum: '5367',
      sActM: '3016',
      sActW: '2351',
      sEmplySum: '5176',
      sEmplyM: '2904',
      sEmplyW: '2272',
      sUnemplySum: '191',
      sUnemplyM: '112',
      sUnemplyW: '79 ',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201512',
      sActSum: '5372',
      sActM: '3015',
      sActW: '2357',
      sEmplySum: '5163',
      sEmplyM: '2895',
      sEmplyW: '2268',
      sUnemplySum: '209',
      sUnemplyM: '120',
      sUnemplyW: '89 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201601',
      sActSum: '5349',
      sActM: '2999',
      sActW: '2350',
      sEmplySum: '5133',
      sEmplyM: '2876',
      sEmplyW: '2257',
      sUnemplySum: '216',
      sUnemplyM: '123',
      sUnemplyW: '93 ',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201602',
      sActSum: '5384',
      sActM: '2999',
      sActW: '2385',
      sEmplySum: '5101',
      sEmplyM: '2849',
      sEmplyW: '2252',
      sUnemplySum: '283',
      sUnemplyM: '150',
      sUnemplyW: '134',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201603',
      sActSum: '5308',
      sActM: '2962',
      sActW: '2346',
      sEmplySum: '5054',
      sEmplyM: '2818',
      sEmplyW: '2237',
      sUnemplySum: '254',
      sUnemplyM: '144',
      sUnemplyW: '109',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201604',
      sActSum: '5328',
      sActM: '2973',
      sActW: '2355',
      sEmplySum: '5098',
      sEmplyM: '2845',
      sEmplyW: '2253',
      sUnemplySum: '229',
      sUnemplyM: '128',
      sUnemplyW: '102',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201605',
      sActSum: '5400',
      sActM: '3003',
      sActW: '2397',
      sEmplySum: '5169',
      sEmplyM: '2878',
      sEmplyW: '2291',
      sUnemplySum: '231',
      sUnemplyM: '125',
      sUnemplyW: '106',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201606',
      sActSum: '5397',
      sActM: '3004',
      sActW: '2393',
      sEmplySum: '5179',
      sEmplyM: '2885',
      sEmplyW: '2295',
      sUnemplySum: '218',
      sUnemplyM: '120',
      sUnemplyW: '98 ',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201607',
      sActSum: '5390',
      sActM: '3021',
      sActW: '2369',
      sEmplySum: '5185',
      sEmplyM: '2907',
      sEmplyW: '2277',
      sUnemplySum: '206',
      sUnemplyM: '114',
      sUnemplyW: '92 ',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201608',
      sActSum: '5370',
      sActM: '3005',
      sActW: '2365',
      sEmplySum: '5145',
      sEmplyM: '2874',
      sEmplyW: '2271',
      sUnemplySum: '225',
      sUnemplyM: '131',
      sUnemplyW: '94 ',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201609',
      sActSum: '5383',
      sActM: '3003',
      sActW: '2380',
      sEmplySum: '5158',
      sEmplyM: '2873',
      sEmplyW: '2286',
      sUnemplySum: '225',
      sUnemplyM: '130',
      sUnemplyW: '95 ',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201610',
      sActSum: '5402',
      sActM: '3002',
      sActW: '2400',
      sEmplySum: '5184',
      sEmplyM: '2881',
      sEmplyW: '2303',
      sUnemplySum: '218',
      sUnemplyM: '121',
      sUnemplyW: '97 ',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201611',
      sActSum: '5385',
      sActM: '3005',
      sActW: '2380',
      sEmplySum: '5184',
      sEmplyM: '2892',
      sEmplyW: '2292',
      sUnemplySum: '201',
      sUnemplyM: '113',
      sUnemplyW: '89 ',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201612',
      sActSum: '5367',
      sActM: '2998',
      sActW: '2369',
      sEmplySum: '5164',
      sEmplyM: '2889',
      sEmplyW: '2275',
      sUnemplySum: '203',
      sUnemplyM: '109',
      sUnemplyW: '94 ',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201701',
      sActSum: '5326',
      sActM: '2980',
      sActW: '2346',
      sEmplySum: '5087',
      sEmplyM: '2841',
      sEmplyW: '2247',
      sUnemplySum: '238',
      sUnemplyM: '139',
      sUnemplyW: '99 ',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201702',
      sActSum: '5401',
      sActM: '3002',
      sActW: '2400',
      sEmplySum: '5112',
      sEmplyM: '2840',
      sEmplyW: '2272',
      sUnemplySum: '289',
      sUnemplyM: '162',
      sUnemplyW: '128',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201703',
      sActSum: '5377',
      sActM: '2991',
      sActW: '2387',
      sEmplySum: '5114',
      sEmplyM: '2847',
      sEmplyW: '2267',
      sUnemplySum: '263',
      sUnemplyM: '144',
      sUnemplyW: '119',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201704',
      sActSum: '5405',
      sActM: '3006',
      sActW: '2399',
      sEmplySum: '5132',
      sEmplyM: '2855',
      sEmplyW: '2277',
      sUnemplySum: '272',
      sUnemplyM: '151',
      sUnemplyW: '122',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201705',
      sActSum: '5404',
      sActM: '3000',
      sActW: '2404',
      sEmplySum: '5177',
      sEmplyM: '2863',
      sEmplyW: '2314',
      sUnemplySum: '227',
      sUnemplyM: '137',
      sUnemplyW: '90 ',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201706',
      sActSum: '5433',
      sActM: '2995',
      sActW: '2438',
      sEmplySum: '5206',
      sEmplyM: '2861',
      sEmplyW: '2345',
      sUnemplySum: '227',
      sUnemplyM: '134',
      sUnemplyW: '93 ',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201707',
      sActSum: '5444',
      sActM: '3011',
      sActW: '2433',
      sEmplySum: '5215',
      sEmplyM: '2872',
      sEmplyW: '2343',
      sUnemplySum: '229',
      sUnemplyM: '139',
      sUnemplyW: '90 ',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201708',
      sActSum: '5434',
      sActM: '2994',
      sActW: '2440',
      sEmplySum: '5185',
      sEmplyM: '2842',
      sEmplyW: '2343',
      sUnemplySum: '249',
      sUnemplyM: '152',
      sUnemplyW: '97 ',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201709',
      sActSum: '5419',
      sActM: '2984',
      sActW: '2435',
      sEmplySum: '5168',
      sEmplyM: '2836',
      sEmplyW: '2332',
      sUnemplySum: '251',
      sUnemplyM: '148',
      sUnemplyW: '103',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201710',
      sActSum: '5385',
      sActM: '2969',
      sActW: '2416',
      sEmplySum: '5161',
      sEmplyM: '2847',
      sEmplyW: '2314',
      sUnemplySum: '224',
      sUnemplyM: '122',
      sUnemplyW: '102',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201711',
      sActSum: '5374',
      sActM: '2964',
      sActW: '2411',
      sEmplySum: '5156',
      sEmplyM: '2848',
      sEmplyW: '2309',
      sUnemplySum: '218',
      sUnemplyM: '116',
      sUnemplyW: '102',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201712',
      sActSum: '5350',
      sActM: '2962',
      sActW: '2388',
      sEmplySum: '5114',
      sEmplyM: '2834',
      sEmplyW: '2279',
      sUnemplySum: '236',
      sUnemplyM: '127',
      sUnemplyW: '109',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201808',
      sActSum: '5330',
      sActM: '2914',
      sActW: '2416',
      sEmplySum: '5066',
      sEmplyM: '2762',
      sEmplyW: '2305',
      sUnemplySum: '264',
      sUnemplyM: '152',
      sUnemplyW: '112',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201809',
      sActSum: '5311',
      sActM: '2893',
      sActW: '2419',
      sEmplySum: '5050',
      sEmplyM: '2754',
      sEmplyW: '2296',
      sUnemplySum: '262',
      sUnemplyM: '139',
      sUnemplyW: '123',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201810',
      sActSum: '5277',
      sActM: '2874',
      sActW: '2403',
      sEmplySum: '5055',
      sEmplyM: '2760',
      sEmplyW: '2295',
      sUnemplySum: '222',
      sUnemplyM: '114',
      sUnemplyW: '108',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201811',
      sActSum: '5291',
      sActM: '2888',
      sActW: '2403',
      sEmplySum: '5089',
      sEmplyM: '2780',
      sEmplyW: '2308',
      sUnemplySum: '202',
      sUnemplyM: '107',
      sUnemplyW: '95',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201812',
      sActSum: '5259',
      sActM: '2888',
      sActW: '2370',
      sEmplySum: '5036',
      sEmplyM: '2751',
      sEmplyW: '2284',
      sUnemplySum: '223',
      sUnemplyM: '137',
      sUnemplyW: '86',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201901',
      sActSum: '5244',
      sActM: '2889',
      sActW: '2355',
      sEmplySum: '4977',
      sEmplyM: '2738',
      sEmplyW: '2238',
      sUnemplySum: '268',
      sUnemplyM: '151',
      sUnemplyW: '117',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
    {
      sDate: '201801',
      sActSum: '5341',
      sActM: '2956',
      sActW: '2385',
      sEmplySum: '5105',
      sEmplyM: '2830',
      sEmplyW: '2275',
      sUnemplySum: '237',
      sUnemplyM: '126',
      sUnemplyW: '110',
      sInactSum: '3199',
      sInactM: '1129',
      sInactW: '2070'
    },
    {
      sDate: '201802',
      sActSum: '5344',
      sActM: '2946',
      sActW: '2398',
      sEmplySum: '5060',
      sEmplyM: '2797',
      sEmplyW: '2263',
      sUnemplySum: '284',
      sUnemplyM: '149',
      sUnemplyW: '135',
      sInactSum: '3194',
      sInactM: '1137',
      sInactW: '2057'
    },
    {
      sDate: '201803',
      sActSum: '5381',
      sActM: '2976',
      sActW: '2404',
      sEmplySum: '5083',
      sEmplyM: '2799',
      sEmplyW: '2284',
      sUnemplySum: '298',
      sUnemplyM: '178',
      sUnemplyW: '121',
      sInactSum: '3153',
      sInactM: '1103',
      sInactW: '2050'
    },
    {
      sDate: '201804',
      sActSum: '5363',
      sActM: '2952',
      sActW: '2412',
      sEmplySum: '5098',
      sEmplyM: '2806',
      sEmplyW: '2291',
      sUnemplySum: '266',
      sUnemplyM: '145',
      sUnemplyW: '120',
      sInactSum: '3169',
      sInactM: '1127',
      sInactW: '2043'
    },
    {
      sDate: '201805',
      sActSum: '5381',
      sActM: '2966',
      sActW: '2415',
      sEmplySum: '5097',
      sEmplyM: '2801',
      sEmplyW: '2296',
      sUnemplySum: '285',
      sUnemplyM: '165',
      sUnemplyW: '120',
      sInactSum: '3149',
      sInactM: '1110',
      sInactW: '2039'
    },
    {
      sDate: '201806',
      sActSum: '5382',
      sActM: '2956',
      sActW: '2426',
      sEmplySum: '5124',
      sEmplyM: '2805',
      sEmplyW: '2318',
      sUnemplySum: '258',
      sUnemplyM: '151',
      sUnemplyW: '107',
      sInactSum: '3147',
      sInactM: '1119',
      sInactW: '2028'
    },
    {
      sDate: '201807',
      sActSum: '5355',
      sActM: '2929',
      sActW: '2426',
      sEmplySum: '5102',
      sEmplyM: '2782',
      sEmplyW: '2321',
      sUnemplySum: '253',
      sUnemplyM: '148',
      sUnemplyW: '105',
      sInactSum: '3167',
      sInactM: '1142',
      sInactW: '2025'
    },
    {
      sDate: '201808',
      sActSum: '5330',
      sActM: '2914',
      sActW: '2416',
      sEmplySum: '5066',
      sEmplyM: '2762',
      sEmplyW: '2305',
      sUnemplySum: '264',
      sUnemplyM: '152',
      sUnemplyW: '112',
      sInactSum: '3186',
      sInactM: '1154',
      sInactW: '2032'
    },
    {
      sDate: '201809',
      sActSum: '5311',
      sActM: '2893',
      sActW: '2419',
      sEmplySum: '5050',
      sEmplyM: '2754',
      sEmplyW: '2296',
      sUnemplySum: '262',
      sUnemplyM: '139',
      sUnemplyW: '123',
      sInactSum: '3199',
      sInactM: '1172',
      sInactW: '2027'
    },
    {
      sDate: '201810',
      sActSum: '5277',
      sActM: '2874',
      sActW: '2403',
      sEmplySum: '5055',
      sEmplyM: '2760',
      sEmplyW: '2295',
      sUnemplySum: '222',
      sUnemplyM: '114',
      sUnemplyW: '108',
      sInactSum: '3227',
      sInactM: '1187',
      sInactW: '2040'
    },
    {
      sDate: '201811',
      sActSum: '5291',
      sActM: '2888',
      sActW: '2403',
      sEmplySum: '5089',
      sEmplyM: '2780',
      sEmplyW: '2308',
      sUnemplySum: '202',
      sUnemplyM: '107',
      sUnemplyW: '95',
      sInactSum: '3207',
      sInactM: '1169',
      sInactW: '2037'
    },
    {
      sDate: '201812',
      sActSum: '5259',
      sActM: '2888',
      sActW: '2370',
      sEmplySum: '5036',
      sEmplyM: '2751',
      sEmplyW: '2284',
      sUnemplySum: '223',
      sUnemplyM: '137',
      sUnemplyW: '86',
      sInactSum: '3234',
      sInactM: '1166',
      sInactW: '2068'
    },
    {
      sDate: '201901',
      sActSum: '5244',
      sActM: '2889',
      sActW: '2355',
      sEmplySum: '4977',
      sEmplyM: '2738',
      sEmplyW: '2238',
      sUnemplySum: '268',
      sUnemplyM: '151',
      sUnemplyW: '117',
      sInactSum: '3241',
      sInactM: '1159',
      sInactW: '2081'
    },
  ],
};

function sActSumFormula(formula) {
  var headCheckRow = formula.Sheet.getRowById('myHeadRow1');
  var sum = 0;

  if (headCheckRow.sActM) { sum += formula.sum('sActM'); }
  if (headCheckRow.sActW) { sum += formula.sum('sActW'); }

  return '[합계]  경제활동 인구(전체) : ' + IBSheet.numberToString(sum, '#,##0') + '명 ';
}

function sEmplySumFormula(formula) {
  var headCheckRow = formula.Sheet.getRowById('myHeadRow1');
  var sum = 0;

  if (headCheckRow.sEmplyM) { sum += formula.sum('sEmplyM'); }
  if (headCheckRow.sEmplyW) { sum += formula.sum('sEmplyW'); }

  return '[합계]  경제활동 인구(취업자) : ' + IBSheet.numberToString(sum, '#,##0') + '명 ';
}

function sUnemplySumFormula(formula) {
  var headCheckRow = formula.Sheet.getRowById('myHeadRow1');
  var sum = 0;

  if (headCheckRow.sUnemplyM) { sum += formula.sum('sUnemplyM'); }
  if (headCheckRow.sUnemplyW) { sum += formula.sum('sUnemplyW'); }

  return '[합계]  경제활동 인구(실업자) ' + IBSheet.numberToString(sum, '#,##0') + '명';
}
